<?php

	/**
	 * Модуль "Формы"
	 *
	 * @package AVE.cms
	 * @subpackage module: forms
	 * @since 1.4
	 * @author vudaltsov
	 * @filesource
	 */

	if (! defined('BASE_DIR'))
		exit;

	/**
	 * Тег
	 *
	 * @param $alias_id
	 */
	function mod_forms($alias_id)
	{
		global $AVE_Template;

		require_once(BASE_DIR . '/modules/forms/class/forms.php');

		$forms = new Forms;
		$forms->tpl_dir = BASE_DIR . '/modules/forms/templates/';

		$lang_file = BASE_DIR . '/modules/forms/lang/' . $_SESSION['user_language'] . '.txt';
		$AVE_Template->config_load($lang_file);

		echo $forms->form_display($alias_id);
	}

	/**
	 * Паблик
	 */
	if (! defined('ACP') && (isset($_REQUEST['module']) && $_REQUEST['module'] == 'forms'))
	{
		global $AVE_Template;

		$alias_id = $_REQUEST['alias_id'];

		require_once(BASE_DIR . '/modules/forms/class/forms.php');

		$forms = new Forms();
		$forms->tpl_dir = BASE_DIR . '/modules/forms/templates/';

		$lang_file = BASE_DIR . '/modules/forms/lang/' . $_SESSION['user_language'] . '.txt';
		$AVE_Template->config_load($lang_file, 'module');

		switch($_REQUEST['action'] ?? '')
		{
			case '':
			case 'full':
				exit ($forms->form_display($alias_id));

			case 'validate':
				$forms->form_display($alias_id);
				$forms->_json($forms->form['ajax'], true);
		}
	}

	/**
	 * Админка
	 */
	if (
		defined('ACP')
		&& (isset($_REQUEST['moduleaction']) && ! empty($_REQUEST['moduleaction']))
		&& (isset($_REQUEST['mod']) && $_REQUEST['mod'] == 'forms')
	)
	{
		$fid = !empty($_REQUEST['fid']) ? (int)$_REQUEST['fid'] : 0;

		require_once(BASE_DIR . '/modules/forms/class/forms.php');

		$forms = new Forms();
		$forms->tpl_dir = BASE_DIR . '/modules/forms/templates/';

		$lang_file = BASE_DIR . '/modules/forms/lang/' . $_SESSION['admin_language'] . '.txt';
		$AVE_Template->config_load($lang_file, 'module');

		$response = '';

		// создаём переменные с версией движка
		$ave14 = ((float)str_replace(',', '.', APP_VERSION) < 1.5);
		$AVE_Template->assign('ave14', $ave14);
		$AVE_Template->assign('ave15', !$ave14);

		switch($_REQUEST['moduleaction'])
		{
			case '1':
				$forms->forms_list();
				break;

			case 'form_edit':
				$response = $forms->form_edit($fid);
				break;

			case 'form_save':
				$response = $forms->form_save($fid);
				// если передан запрос на обновление полей, передаём tpl
				if (isset($_REQUEST['fields_reload']) && $_REQUEST['fields_reload'] == 1)
				{
					exit ($forms->form_fields_fetch());
				}
				break;

			case 'form_del':
				$forms->form_del($fid);
				header('Location: index.php?do=modules&action=modedit&mod=forms&moduleaction=1&cp=' . SESSION);
				exit;

			case 'form_copy':
				$fid_new = $forms->form_copy($fid);
				$_SESSION['module_forms_admin'][$fid_new]['edit_alert'] = array('text' => 'copied', 'theme' => 'accept');
				header('Location: index.php?do=modules&action=modedit&mod=forms&moduleaction=form_edit&fid=' . $fid_new . '&cp=' . SESSION);
				exit;

			case 'email_validate':
				$response = (int)$forms->_email_validate($_REQUEST['email']);
				break;

			case 'alias_validate':
				$response = $forms->_alias_validate($_REQUEST['alias'],$fid);
				$response = ($response === 'syn') ? 'syn' : (int)$response;
				break;

			case 'history_list':
				$forms->history_list($fid);
				break;

			case 'email_del':
				$hid = !empty($_REQUEST['hid']) ? (int)$_REQUEST['hid'] : 0;
				$forms->email_del($hid);
				$fid = !empty($_REQUEST['fid']) ? (int)$_REQUEST['fid'] : 0;
				header('Location: index.php?do=modules&action=modedit&mod=forms&moduleaction=history_list&fid=' . $fid . '&cp=' . SESSION);
				exit;

			case 'history_dialog':
				$hid = !empty($_REQUEST['hid']) ? (int)$_REQUEST['hid'] : 0;
				$forms->history_dialog($hid);
				break;

			case 'history_dialog_submit':
				$hid = !empty($_REQUEST['hid']) ? (int)$_REQUEST['hid'] : 0;
				$forms->history_dialog_submit($hid);
				break;

			case 'dialog_status':
				$hid = !empty($_REQUEST['hid']) ? (int)$_REQUEST['hid'] : 0;
				$forms->dialog_status($hid);
				break;
		}

	if ($_REQUEST['ajax'] ?? false)
    exit((string)$response);
}
?>